﻿function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
		    [Parameter(Mandatory=$false)]
		    $Component,
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage.Replace("`0","") | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

$tsenv = New-Object -ComObject Microsoft.SMS.TSEnvironment
$LogPath = $tsenv.Value('_SMSTSLogPath')
$LogFile = "$LogPath\WaaS_LangPack.log"
$SMSTS_WinSystemLocale = $tsenv.Value('SMSTS_WinSystemLocale')

#$LangPackageLocation = $tsenv.Value('LANG01')
#$WaaSLangPacksFolder = "$env:ProgramData\WaaS\WaaSLangPacks"
$WaaSLangPacksFolder = $tsenv.Value('LANG01')

$Mode = $tsenv.Value('SMSTS_TSWaaSMode') #This Var is set at the start of each TS
if ($Mode -ne $null)
    {
    if ($Mode -eq "Upgrade")
    {
    $CurrentOSInfo = Get-Item -Path 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion'
    $ReleaseID_CurrentOS = $CurrentOSInfo.GetValue('ReleaseId')
    if ($ReleaseID_CurrentOS -eq $tsenv.Value('SMSTS_Build'))
        {
        $ComponetSuffix = "PostSetup"
        }
    Else
        {
        $ComponetSuffix = "PreSetup"
        }    
    $Component = "$($mode):LP:$($ComponetSuffix)"
    }
    Else
        {$Component = "$($mode):LP"}
    }
else {$Component = "LXP"}

CMTraceLog -Message  "" -Type 1 -LogFile $LogFile -Component $Component
Write-Output "-------------------------------------------"
Write-Output "Starting Language Local Experience Pack Script"

if (Test-Path "$WaaSLangPacksFolder\LocalExperiencePack")
    {

    #Install Local Experience Packs (LXP)
    $LXPFiles = Get-ChildItem -Path "$WaaSLangPacksFolder\LocalExperiencePack\*" -Include *.appx
    Foreach ($LXPFile in $LXPFiles)
        {
        CMTraceLog -Message  "  Installing LXP $($LXPFile.FullName)" -Type 1 -LogFile $LogFile -Component $Component
        Add-AppxProvisionedPackage -Online -PackagePath $LXPFile.FullName  -LicensePath "$WaaSLangPacksFolder\LocalExperiencePack\License.xml" -Verbose
        }
    }


#Reporting
$InstalledLXPs = Get-ProvisionedAppxPackage -Online | Where-Object {$_.DisplayName -match "Microsoft.LanguageExperiencePack"}
CMTraceLog -Message  " Checking installed LXPs" -Type 1 -LogFile $LogFile -Component $Component
ForEach ($InstalledLXP in $InstalledLXPs)
    {
    CMTraceLog -Message  "  Found Installed LXP $($InstalledLXP.DisplayName)" -Type 1 -LogFile $LogFile -Component $Component
    CMTraceLog -Message  "  Version: $($InstalledLXP.Version)" -Type 1 -LogFile $LogFile -Component $Component
    CMTraceLog -Message  "  PackageName: $($InstalledLXP.PackageName)" -Type 1 -LogFile $LogFile -Component $Component
    }

Get-ProvisionedAppxPackage -Online | Where-Object {$_.DisplayName -match "Microsoft.LanguageExperiencePack"}

Write-Output "Finished Language Local Expereince Pack Script"
Write-Output "-------------------------------------------"
